


// *******************************************************************
// Computation of steady state
// *******************************************************************

Ass = 2;                // Steady-state value of technology
Hss=10;                 // Steady-state value of Housing
//Hss = 6.90645;        // Steady-state value of Housing that ensures Q=1 in steady state

//% *******************************************************************
//% Analytical expressions available
//% *******************************************************************

Rss = 1/betaP;       // Loan rate determined by most patient household
QKss = 1;            // Price of installed capital equal to price of new,
                     // as there are no adjustment costs in steady state

//BE_Yss = (n/nE)*betaP*sbarE*betaE*(1-gamma)*( (1-phi)/(1-(betaP-betaE)*sbarE-betaE*(1-delta)) + phi/(1-betaE-(betaP-betaE)*sbarE) );  
//BE_Yss = (n/nE)*betaP*sbarE*betaE*(1-gamma)*((1-phi)*(1-betaE*(1-varthetaE))/((1-betaE*(1-varthetaE))*(1-betaE*(1-delta))-(betaP-betaE)*varthetaE*sbarE) + phi*(1-betaE*(1-varthetaE))/((1-betaE*(1-varthetaE))*(1-betaE)-(betaP-betaE)*varthetaE*sbarE));
BE_Yss = (varthetaE/(1-(1-varthetaE)*(1-xiE)))*(n/nE)*betaP*sbarE*betaE*(1-gamma)*((1-phi)*(1-betaE*(1-varthetaE)*(1-xiE))/((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE*(1-delta))-(betaP-betaE)*varthetaE*sbarE) + phi*(1-betaE*(1-varthetaE)*(1-xiE))/((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE)-(betaP-betaE)*varthetaE*sbarE));
                     // Entrepeneurs' debt per agent as ratio to output 
                     // per firm in steady state
                        
// ********************************************************************
// Numerical derivation of seven key quantities in a vector x
// ********************************************************************

x0 = [1; 1; 2; 4; 4; 1/3; 1/3];    // Initial guess for fsolve
[x,fval] = fsolve(@ssfunm7revision2,x0,[],gamma,phi,betaP,BE_Yss,nuP,nuI,sigmanP,sigmanI,...
                      sigmacP,sigmacI,alpha,sigmahI,Hss,sigmahP,...
                      epsilonI,epsilonP,betaI,sbarI,betaE,sbarE,...
                      Ass,delta,nI,nE,n,rhoP,rhoI,varthetaI,varthetaE,xiI,xiE) ;

// Giving the solutions their appropriate steady-state names                
                  
Yss  = x(1) ;    // Output
CPss = x(2) ;    // Consumption, patient HHs
CIss = x(3) ;    // Consumption, impatient HHs
HIss = x(4) ;    // Land, impatient HHs
HEss = x(5) ;    // Land, entrepeneurs
NPss = x(6) ;    // Labour, patient HHs
NIss = x(7) ;    // Labour, impatient HHs
 
// ********************************************************************
// Analytical computations of remaining steady-state variables
// ********************************************************************

lambdaPss = ((1-betaP*rhoP)/(CPss*(1-rhoP)));                               
WPss = (nuP*(1-NPss)^-sigmanP)/lambdaPss;                                   
HPss = (Hss - nI*HIss - nE*HEss)/(1-nI-nE);                                 
Qss  = (epsilonP*HPss^(-sigmahP)/(lambdaPss*(1-betaP)));                    

lambdaIss = ((1-betaI*rhoI)/(CIss*(1-rhoI)));                               
//muIss = lambdaIss*(1-(betaI/betaP));                                      
//muIss = (lambdaIss*(1-(betaI/betaP)))/(1-betaI*(1-varthetaI)); 
muIss = (lambdaIss*(1-(betaI/betaP)))/(1-betaI*(1-varthetaI)*(1-xiI));              
WIss = (nuI*(1-NIss)^-sigmanI)/lambdaIss;                                   

//Kss  = (n/nE)*Yss*betaE*(1-gamma)*(1-phi)/(1-(betaP-betaE)*sbarE-betaE*(1-delta)) ;
Kss  = ((n/nE)*Yss*betaE*(1-gamma)*(1-phi)*(1-betaE*(1-varthetaE)*(1-xiE)))/((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE*(1-delta))-(betaP-betaE)*sbarE*varthetaE*QKss) ;    //SHR 31/7 2018: Use this instead?    
//Kss  = ((n/nE)*Yss*betaE*(1-gamma)*(1-phi)*(1-betaE*(1-varthetaE)))/((1-betaE*(1-varthetaE))*(1-betaE*(1-delta))-(betaP-betaE)*sbarE*varthetaE*QKss) ;   
Iss  = delta*Kss;                                                           
//CEss = (n/nE)*Yss*(1-gamma)*(1-phi)*(1-betaE-(betaP-betaE)*sbarE)/(1-(betaP-betaE)*sbarE-betaE*(1-delta)) + (1-gamma)*phi*(n/nE)*Yss - ((1-betaP)/betaP)*BE_Yss*Yss; 
//CEss=(n/nE)*Yss*(1-gamma)*(1-phi)*((1-betaE*(1-varthetaE))*(1-betaE)-(betaP-betaE)*varthetaE*sbarE*QKss)/((1-betaE*(1-varthetaE))*(1-betaE*(1-delta))-(betaP-betaE)*varthetaE*sbarE)+(1-gamma)*phi*(n/nE)*Yss-((1-betaP)/betaP)*BE_Yss*Yss;
CEss=(n/nE)*Yss*(1-gamma)*(1-phi)*((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE)-(betaP-betaE)*varthetaE*sbarE*QKss)/((1-betaE*(1-varthetaE)*(1-xiE))*(1-betaE*(1-delta))-(betaP-betaE)*varthetaE*sbarE)+(1-gamma)*phi*(n/nE)*Yss-((1-betaP)/betaP)*BE_Yss*Yss;
//lambdaEss = ((1-betaE*rhoI)/(CEss*(1-rhoI)));   
lambdaEss = ((1-betaE*rhoE)/(CEss*(1-rhoE)));                               
//muEss = lambdaEss*(1-(betaE/betaP));                                      
//muEss = (lambdaEss*(1-(betaE/betaP)))/(1-betaE*(1-varthetaE));  
muEss = (lambdaEss*(1-(betaE/betaP)))/(1-betaE*(1-varthetaE)*(1-xiE));            
psiEss = lambdaEss;                                                         
//rKss  = delta - 1 + (1-(betaP-betaE)*sbarE*QKss)/betaE ;
//rKss = delta - 1 + (1-betaE*(1-varthetaE)-(betaP-betaE)*varthetaE*sbarE*QKss)/(betaE*(1-betaE*(1-varthetaE)));  
rKss = delta - 1 + (1-betaE*(1-varthetaE)*(1-xiE)-(betaP-betaE)*varthetaE*sbarE*QKss)/(betaE*(1-betaE*(1-varthetaE)*(1-xiE)));  
//rHss  = Qss*( (1-betaE)/betaE - muEss*sbarE/(lambdaEss*betaE*Rss) ); 
rHss  = Qss*( (1-betaE)/betaE - muEss*varthetaE*sbarE/(lambdaEss*betaE*Rss) ); 

//BIss = sbarI*Qss*HIss/Rss ; 
BIss = (varthetaI/(1-(1-varthetaI)*(1-xiI)))*sbarI*Qss*HIss/Rss ;                                 
//BEss = sbarE*QKss*Kss/Rss + sbarE*Qss*HEss/Rss; 
BEss = (varthetaE/(1-(1-varthetaE)*(1-xiE)))*(sbarE*QKss*Kss/Rss + sbarE*Qss*HEss/Rss);             
BPss = (- nI*BIss - nE*BEss)/(1-nI-nE) ;                    

Ctotss=((1-nI-nE)*CPss+nI*CIss+nE*CEss)/n;                  
Ntotss=((1-nI-nE)*NPss+nI*NIss)/(2*n);                      

//Put steady state values in a vector with variables in declaration order:
steadys = [CPss CIss CEss lambdaPss lambdaIss lambdaEss psiEss muIss muEss Rss NPss NIss WPss WIss HPss HIss HEss Qss QKss rKss rHss Kss Iss Yss BPss BIss BEss Ctotss Ntotss 0 0 0 0]';
